; Copyleft (c) n/a-n/a Azure Zanculmarktum
; You can modify my source, but you can't modify my brain!!

!define BUILDDATE "13 janvier 2014"
!define APPNAME "Office Tab"
!define APP "OfficeTab"
!define APPVER "0.0.0.0"
!define VER "1.0"
!define APPDIR "OfficeTab"

; === Languages ===
LoadLanguageFile "${NSISDIR}\Contrib\Language files\French.nlf"

; === Program Details ===
Name "${APPNAME} Portable"
OutFile "..\..\${APP}Portable.exe"
Caption "${APPNAME} Portable | PerkedleApps"
VIProductVersion "${APPVER}"
VIAddVersionKey /LANG=${LANG_FRENCH} BuildDate "${BUILDDATE} ${__TIME__}"
VIAddVersionKey /LANG=${LANG_FRENCH} ProductName "${APPNAME} Portable"
VIAddVersionKey /LANG=${LANG_FRENCH} Comments "Allows ${APPNAME} to be run from a removable drive."
VIAddVersionKey /LANG=${LANG_FRENCH} CompanyName "PerkedleApps"
VIAddVersionKey /LANG=${LANG_FRENCH} LegalCopyright "Azure Zanculmarktum"
VIAddVersionKey /LANG=${LANG_FRENCH} FileDescription "${APPNAME} Portable"
VIAddVersionKey /LANG=${LANG_FRENCH} FileVersion "${APPVER}"
VIAddVersionKey /LANG=${LANG_FRENCH} ProductVersion "${VER}"
VIAddVersionKey /LANG=${LANG_FRENCH} InternalName "${APPNAME}"
VIAddVersionKey /LANG=${LANG_FRENCH} LegalTrademarks "PerkedleApps is a Trademark of Azure Zanculmarktum"
VIAddVersionKey /LANG=${LANG_FRENCH} OriginalFilename "${APP}Portable.exe"

; === Runtime Switches ===
XPStyle on
CRCCheck on
WindowIcon off
SilentInstall silent
AutoCloseWindow true
RequestExecutionLevel user

; === Best Compression ===
SetCompress auto
SetCompressor /SOLID lzma
SetCompressorDictSize 32
SetDatablockOptimize on

; === Include ===
!include FileFunc.nsh
!insertmacro GetParameters
!include WordFunc.nsh
!insertmacro WordFindS
!include LogicLib.nsh
!include Include\Macros.nsh
!include Include\SystemMessageBox.nsh

; === Program Icon ===
Icon "${APP}.ico"

Var PARAMETERS
Var INSTALLPORTABLE
Var UNINSTALLPORTABLE
Var ARCHITECTURE
Var PROGRAMDIR
Var SETTINGSDIR

Section "Main"
	; === Get passed parameters ===
	${GetParameters} $PARAMETERS
	${WordFindS} "$PARAMETERS" "-installPortable" "*" $0
	IntCmp $0 "0" +3 +3
		StrCpy $INSTALLPORTABLE "true"
		Goto CheckRunning
	${WordFindS} "$PARAMETERS" "-unInstallPortable" "*" $0
	IntCmp $0 "0" +3 +3
		StrCpy $UNINSTALLPORTABLE "true"
		Goto CheckRunning

	; === No passed parameters ===
	Goto TheEnd

	CheckRunning:
		System::Call `kernel32::CreateMutexA(i 0, i 0, t "$(^Name)") i .r0 ?e` ; check if launcher is already running
		Pop $0
		StrCmp $0 "0" SetDefaultVariables
			Goto TheEnd

	SetDefaultVariables:
		System::Call `kernel32::GetCurrentProcess()i.s`
		System::Call `kernel32::IsWow64Process(is,*i.s)`
		Pop $0
		StrCmp $0 "0" "" +2
			StrCpy $ARCHITECTURE "x86"
		StrCmp $0 "1" "" +2
			StrCpy $ARCHITECTURE "x64"

		StrCpy $PROGRAMDIR "$EXEDIR\files"
		StrCpy $SETTINGSDIR "$EXEDIR\Data\${APPDIR}"

		StrCmp $INSTALLPORTABLE "true" Init
		StrCmp $UNINSTALLPORTABLE "true" Close

	Init:
		; === Backup local registry keys ===
		${registry::BackupLocal} "HKEY_CURRENT_USER\Software\ExtendOffice"
		${registry::BackupLocal} "HKEY_LOCAL_MACHINE\SOFTWARE\ExtendOffice\Office Tab"

		registry::_KeyExists /NOUNLOAD "HKEY_CURRENT_USER\Software\Licenses"
		Pop $0
		StrCmp $0 "-1" +3
			CreateDirectory "$EXEDIR\Data"
				WriteINIStr "$EXEDIR\Data\${APP}Portable.ini" "${APP}Portable" "HKCULicensesKeyExists" "true"
		registry::_KeyExists /NOUNLOAD "HKEY_CURRENT_USER\Software\The Silicon Realms Toolworks"
		Pop $0
		StrCmp $0 "-1" +3
			CreateDirectory "$EXEDIR\Data"
				WriteINIStr "$EXEDIR\Data\${APP}Portable.ini" "${APP}Portable" "TheSiliconRealmsToolworksKeyExists" "true"
		registry::_KeyExists /NOUNLOAD "HKEY_LOCAL_MACHINE\SOFTWARE\Licenses"
		Pop $0
		StrCmp $0 "-1" +3
			CreateDirectory "$EXEDIR\Data"
				WriteINIStr "$EXEDIR\Data\${APP}Portable.ini" "${APP}Portable" "HKLMLicensesKeyExists" "true"
		registry::_KeyExists /NOUNLOAD "HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\RFC1156Agent"
		Pop $0
		StrCmp $0 "-1" +3
			CreateDirectory "$EXEDIR\Data"
				WriteINIStr "$EXEDIR\Data\${APP}Portable.ini" "${APP}Portable" "RFC1156AgentKeyExists" "true"

		; === Restore registry settings from .reg file ===
		${registry::RestorePortable}

		; === Backup local directories ===
		${directory::BackupLocal} "$APPDATA\OfficeTab" ""
		SetShellVarContext all
			IfFileExists "$APPDATA\Licenses\*.*" "" +3
				CreateDirectory "$EXEDIR\Data"
					WriteINIStr "$EXEDIR\Data\${APP}Portable.ini" "${APP}Portable" "Licenses" "true"
			IfFileExists "$APPDATA\TEMP\*.*" "" +3
				CreateDirectory "$EXEDIR\Data"
					WriteINIStr "$EXEDIR\Data\${APP}Portable.ini" "${APP}Portable" "TEMP" "true"
		SetShellVarContext current

		; === Restore portable directory ===
		${directory::RestorePortable} "$APPDATA\OfficeTab" "" "$SETTINGSDIR"

		; === Unregister local libraries ===
		${dll::UnRegLocal} "{05DD84BD-0C52-460B-B32C-F1A269806EF6}" "TabsforOffice32.dll"
		${dll::UnRegLocal} "{3AFC388C-F64C-4B45-A7A8-0F899C29F4BE}" "TabsforOffice32.dll"
		${dll::UnRegLocal} "{7539460D-D647-43AB-A9A0-8FF97F039C65}" "TabsforOffice32.dll"
		${dll::UnRegLocal} "{82B17687-FD95-4610-A48C-A01082E4AF0A}" "TabsforOffice32.dll"
		${dll::UnRegLocal} "{9899B599-4396-4A05-9A13-4DA9D815FF90}" "TabsforOffice32.dll"
		${dll::UnRegLocal} "{C8ECD8DB-53FF-4346-852F-128F90FBBB75}" "TabsforOffice32.dll"
		${dll::UnRegLocal} "{E6E84EFE-DFD8-4CAB-95F8-7BEBE469F29A}" "TabsforOffice32.dll"
		${dll::UnRegLocal} "{C17F25FC-32B7-4F49-AF59-5747FE712CB1}" "TabsforOfficeHelper32.dll"

		; === Register portable libraries ===
		RegDLL "$PROGRAMDIR\TabsforOffice32.dll"
		RegDLL "$PROGRAMDIR\TabsforOfficeHelper32.dll"

		; === Load default settings ===
		WriteRegStr HKEY_CURRENT_USER "Software\ExtendOffice\TabsforExcel" "Enable" "1"
		WriteRegStr HKEY_CURRENT_USER "Software\ExtendOffice\TabsforPowerPoint" "Enable" "1"
		WriteRegStr HKEY_CURRENT_USER "Software\ExtendOffice\TabsforWord" "Enable" "1"

		IfFileExists "$EXEDIR\Data\${APP}.reg" +4 ; used on first run
			WriteRegStr HKEY_CURRENT_USER "Software\ExtendOffice\TabsforExcel" "TabBarStyle" "5"
			WriteRegStr HKEY_CURRENT_USER "Software\ExtendOffice\TabsforPowerPoint" "TabBarStyle" "5"
			WriteRegStr HKEY_CURRENT_USER "Software\ExtendOffice\TabsforWord" "TabBarStyle" "5"

		WriteRegStr HKEY_LOCAL_MACHINE "SOFTWARE\Microsoft\Office\Excel\Addins\OfficeTab.TabsforExcel" "Description" "Tabs for Excel     (32-bit)"
		WriteRegStr HKEY_LOCAL_MACHINE "SOFTWARE\Microsoft\Office\Excel\Addins\OfficeTab.TabsforExcel" "FriendlyName" "Tabs for Excel     (32-bit)"
		WriteRegDWORD HKEY_LOCAL_MACHINE "SOFTWARE\Microsoft\Office\Excel\Addins\OfficeTab.TabsforExcel" "LoadBehavior" 0x3
		WriteRegStr HKEY_LOCAL_MACHINE "SOFTWARE\Microsoft\Office\Excel\Addins\TabsforOfficeHelper.Helper" "Description" "Office Tab Helper"
		WriteRegStr HKEY_LOCAL_MACHINE "SOFTWARE\Microsoft\Office\Excel\Addins\TabsforOfficeHelper.Helper" "FriendlyName" "Office Tab Helper"
		WriteRegDWORD HKEY_LOCAL_MACHINE "SOFTWARE\Microsoft\Office\Excel\Addins\TabsforOfficeHelper.Helper" "LoadBehavior" 0x3

		WriteRegStr HKEY_LOCAL_MACHINE "SOFTWARE\Microsoft\Office\PowerPoint\Addins\OfficeTab.TabsforPowerPoint" "Description" "Tabs for PowerPoint     (32-bit)"
		WriteRegStr HKEY_LOCAL_MACHINE "SOFTWARE\Microsoft\Office\PowerPoint\Addins\OfficeTab.TabsforPowerPoint" "FriendlyName" "Tabs for PowerPoint     (32-bit)"
		WriteRegDWORD HKEY_LOCAL_MACHINE "SOFTWARE\Microsoft\Office\PowerPoint\Addins\OfficeTab.TabsforPowerPoint" "LoadBehavior" 0x3
		WriteRegStr HKEY_LOCAL_MACHINE "SOFTWARE\Microsoft\Office\PowerPoint\Addins\TabsforOfficeHelper.Helper" "Description" "Office Tab Helper"
		WriteRegStr HKEY_LOCAL_MACHINE "SOFTWARE\Microsoft\Office\PowerPoint\Addins\TabsforOfficeHelper.Helper" "FriendlyName" "Office Tab Helper"
		WriteRegDWORD HKEY_LOCAL_MACHINE "SOFTWARE\Microsoft\Office\PowerPoint\Addins\TabsforOfficeHelper.Helper" "LoadBehavior" 0x3

		WriteRegStr HKEY_LOCAL_MACHINE "SOFTWARE\Microsoft\Office\Word\Addins\OfficeTab.TabsforWord" "Description" "Tabs for Word      (32-bit)"
		WriteRegStr HKEY_LOCAL_MACHINE "SOFTWARE\Microsoft\Office\Word\Addins\OfficeTab.TabsforWord" "FriendlyName" "Tabs for Word      (32-bit)"
		WriteRegDWORD HKEY_LOCAL_MACHINE "SOFTWARE\Microsoft\Office\Word\Addins\OfficeTab.TabsforWord" "LoadBehavior" 0x3
		WriteRegStr HKEY_LOCAL_MACHINE "SOFTWARE\Microsoft\Office\Word\Addins\TabsforOfficeHelper.Helper" "Description" "Office Tab Helper"
		WriteRegStr HKEY_LOCAL_MACHINE "SOFTWARE\Microsoft\Office\Word\Addins\TabsforOfficeHelper.Helper" "FriendlyName" "Office Tab Helper"
		WriteRegDWORD HKEY_LOCAL_MACHINE "SOFTWARE\Microsoft\Office\Word\Addins\TabsforOfficeHelper.Helper" "LoadBehavior" 0x3

		Goto TheEnd

	Close:
		; === Unregister portable libraries ===
		UnRegDLL "$PROGRAMDIR\TabsforOffice32.dll"
		UnRegDLL "$PROGRAMDIR\TabsforOfficeHelper32.dll"

		; === Register local libraries ===
		${dll::RegLocal} "TabsforOffice32.dll"
		${dll::RegLocal} "TabsforOfficeHelper32.dll"

		; === Backup portable directory ===
		${directory::BackupPortable} "$SETTINGSDIR" "$APPDATA\OfficeTab" ""

		; === Restore local directories ===
		${directory::RestoreLocal} "$APPDATA\OfficeTab" ""
		SetShellVarContext all
			ReadINIStr $0 "$EXEDIR\Data\${APP}Portable.ini" "${APP}Portable" "Licenses"
			StrCmp $0 "true" +2
				RMDir /r "$APPDATA\Licenses"
			ReadINIStr $0 "$EXEDIR\Data\${APP}Portable.ini" "${APP}Portable" "TEMP"
			StrCmp $0 "true" +2
				RMDir /r "$APPDATA\TEMP"
		SetShellVarContext current

		; === Save registry keys into .reg file ===
		Delete "$EXEDIR\Data\${APP}.reg"
		CreateDirectory "$EXEDIR\Data"
			${registry::BackupPortable} "HKEY_CURRENT_USER\Software\ExtendOffice"

		; === Restore local registry keys ===
		${registry::RestoreLocal} "HKEY_CURRENT_USER\Software\ExtendOffice"
		${registry::RestoreLocal} "HKEY_LOCAL_MACHINE\SOFTWARE\ExtendOffice\Office Tab"

		ReadINIStr $0 "$EXEDIR\Data\${APP}Portable.ini" "${APP}Portable" "HKCULicensesKeyExists"
		StrCmp $0 "true" +2
			DeleteRegKey HKEY_CURRENT_USER "Software\Licenses"
		ReadINIStr $0 "$EXEDIR\Data\${APP}Portable.ini" "${APP}Portable" "TheSiliconRealmsToolworksKeyExists"
		StrCmp $0 "true" +2
			DeleteRegKey HKEY_CURRENT_USER "Software\The Silicon Realms Toolworks"
		ReadINIStr $0 "$EXEDIR\Data\${APP}Portable.ini" "${APP}Portable" "HKLMLicensesKeyExists"
		StrCmp $0 "true" +2
			DeleteRegKey HKEY_LOCAL_MACHINE "SOFTWARE\Licenses"
		ReadINIStr $0 "$EXEDIR\Data\${APP}Portable.ini" "${APP}Portable" "RFC1156AgentKeyExists"
		StrCmp $0 "true" +2
			DeleteRegKey HKEY_LOCAL_MACHINE "SOFTWARE\Microsoft\RFC1156Agent"

		Delete "$EXEDIR\Data\${APP}Portable.ini"

		; === Delete registry key if empty ===
		registry::_DeleteKeyEmpty /NOUNLOAD "HKEY_LOCAL_MACHINE\SOFTWARE\ExtendOffice"

	TheEnd:
		; === Unload plug-in ===
		registry::_Unload ; unload registry plug-in
SectionEnd